<?php
/**
 * Mu Roulette
 * https://webenginecms.org/
 * 
 * @version 1.0.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

if(!isLoggedIn()) redirect(1,'login');

echo '<div class="page-title"><span>'.lang('roulette_title_results').'</span></div>';

try {
	
	$MuRoulette = new \Plugin\MuRoulette\MuRoulette();
	$MuRoulette->setUsername($_SESSION['username']);
	$spinHistory = $MuRoulette->getAccountSpinHistory();
	if(!is_array($spinHistory)) throw new Exception(lang('roulette_error_26'));
	
	if(check_value($_GET['redeem'])) {
		message('success', lang('roulette_success_1'));
	}
	
	echo '<table class="table table-bordered table-striped">';
	echo '<thead>';
		echo '<tr>';
			echo '<th>'.lang('roulette_txt_9').'</th>';
			echo '<th>'.lang('roulette_txt_10').'</th>';
			echo '<th>'.lang('roulette_txt_11').'</th>';
			echo '<th></th>';
		echo '</tr>';
	echo '<thead>';
	echo '<tbody>';
	foreach($spinHistory as $row) {
		echo '<tr>';
			echo '<td>'.$row['spin_date'].'</td>';
			echo '<td>'.$row['character'].'</td>';
			echo '<td>'.number_format($row['reward_amount']).' '.$row['reward_type'].'</td>';
			echo '<td class="text-center">';
			if($row['reward_redeem_status'] == 0) {
				echo '<a href="'.__ROULETTE_HOME__.'redeem/ticket/'.$row['id'].'" class="btn btn-xs btn-primary">'.lang('roulette_txt_12').'</a>';
			} else {
				echo '<span class="label label-success">'.lang('roulette_txt_13').'</span>';
			}
			echo '</td>';
		echo '</tr>';
	}
	echo '</tbody>';
	echo '</table>';
	
	
} catch(Exception $ex) {
	message('error', $ex->getMessage());
}